/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.eap.cloudsdk;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomSSLContext {
    private static final Logger logger = LoggerFactory.getLogger(CustomSSLContext.class);
    private static final String KEY_STORE_PASS = "tplink";
    private static final String TP_KEY_STORE = "tpKeyStore";

    public static SSLSocketFactory getSocketFactory() {
        return CustomSSLContext.getSSLContext().getSocketFactory();
    }

    public static SSLContext getSSLContext() {
        SSLContext ctx = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(ClassLoader.getSystemResourceAsStream(TP_KEY_STORE), KEY_STORE_PASS.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            TrustManager[] trustManagers = tmf.getTrustManagers();
            final X509TrustManager origTrustmanager = (X509TrustManager)trustManagers[0];
            TrustManager[] wrappedTrustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return origTrustmanager.getAcceptedIssuers();
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                    origTrustmanager.checkClientTrusted(certs, authType);
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                    block3: {
                        try {
                            origTrustmanager.checkServerTrusted(certs, authType);
                        }
                        catch (CertificateException e) {
                            boolean rethwow = true;
                            Throwable cause = e.getCause();
                            if (cause != null && cause instanceof CertPathValidatorException && (cause = cause.getCause()) != null && (cause instanceof CertificateNotYetValidException || cause instanceof CertificateExpiredException)) {
                                logger.warn("Ignores certification exception:{}.", (Object)cause.toString());
                                rethwow = false;
                            }
                            if (!rethwow) break block3;
                            throw e;
                        }
                    }
                }
            }};
            ctx = SSLContext.getInstance("TLS");
            ctx.init(null, wrappedTrustManagers, null);
        }
        catch (GeneralSecurityException e) {
            logger.error(e.toString(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.toString(), (Throwable)e);
        }
        return ctx;
    }
}

